/* An example of running a RAM-based REXX script */

#ifdef WIN32
#include <windows.h>
#endif
#include <stdio.h>
#include "..\rexxsaa.h"

/* Here's our REXX script. It doesn't have
   to be nul-terminated, but we'll make it so
   just because it's easier to declare here in C */
char myScript[] = {"SAY 'Hello World';EXIT"};

int main(int argc, char **argv)
{
	RXSTRING	instore[2];		/* We're going to use this to run a script in memory and add it to the interpreter's macro table */
	APIRET		err;
	char		chr;

	/* Initialize the RXSTRING to pass RexxStart() a script in RAM */
	instore[0].strptr = myScript;
	instore[0].strlength = strlen(myScript);
	instore[1].strptr = 0;

	/* Run the REXX script in RAM. Name it "Test Script" */
	err = RexxStart(0, 0, "Test Script",
					&instore[0],		/* Here we pass our script directly */
					0, RXSUBROUTINE, 0, 0, 0);

	/* Was there an error running the script? */
	if (err)
	{
		/* Yes. Print the error number except if using Reginald. Reginald's RexxStart()
		   always displays the error for you. Other interpreters are inconsistent.
		   Sometimes they do and sometimes they don't
		*/
#ifndef USING_REGINALD
		printf("RexxStart() error: %d\n", err);
#endif
	}

	/* We must free the tokenized version when we're done with it. We wouldn't do
	 * this yet if we intended to call RexxStart() again for this script.
	 */

#ifdef REGINALD_EXTENSIONS
	/* Reginald allows deleting the macro from Reginald's table via RexxStart(). In
	 * that case, Reginald frees the data buffer too
	 */
	instore[0].strptr = 0;
	RexxStart(0, 0, "Test Script", &instore[0], 0, RXSUBROUTINE, 0, 0, 0);
#else
	/* For other interpreters, we must free the tokenized version ourselves */
	if (instore[1].strptr) RexxFreeMemory(instore[1].strptr);
#endif

	/* Wait for user to press ENTER before ending */
	printf("Press ENTER to end...\n");
	scanf("%c", &chr);

	return(0);
}
