/* Receiving a value from the script, and we provide the data buffer for that */

#ifdef WIN32
#include <windows.h>
#endif
#include <stdio.h>
#include "..\rexxsaa.h"

int main(int argc, char **argv)
{
	RXSTRING	rx;
	APIRET		err;

	/* Create our buffer right on the stack */
	char		buffer[80];

	rx.strptr = buffer;
	rx.strlength = sizeof(buffer);

	/* Run the REXX Script named "test.rex" in the current directory */
	err = RexxStart(0, 0,
					"test.rex",    /* name of REXX script */
					0, 0, RXSUBROUTINE, 0, 0, &rx);

	/* Was there an error running the script? */
	if (err)
	{
		/* Yes. Print the error number except if using Reginald. Reginald's RexxStart()
		   always displays the error for you. Other interpreters are inconsistent.
		   Sometimes they do and sometimes they don't
		*/
#ifndef USING_REGINALD
		printf("RexxStart() error: %d\n", err);
#endif
		/* It's our responsibility to free this RXSTRING's
			data buffer. The interpreter shouldn't have returned anything,
			but let's play it safe and avoid a memory leak */
		if (rx.strptr && rx.strptr != buffer) RexxFreeMemory(rx.strptr);
	}

	/* Display what the script returned */
	else
	{
		/* Did the script return something? It may not have,
			in which case rx's strptr field will still be 0 */
		if (rx.strptr)
		{
			/* It's not necessarily nul-terminated, so we can't treat
			  it as a C string. Do we have room to add a nul byte? */
			if (rx.strlength < sizeof(buffer))
			{
				/* Yeah! Turn it into a C string */
				buffer[rx.strlength] = 0;
				printf("%s\n", buffer);
			}
   
			else
			{
				for (err = 0; err < rx.strlength; err++)
				{
					printf("%c", rx.strptr[err]);
				}
				printf("\n");
			}

			/* It's our responsibility to free this RXSTRING's
				data buffer if it's not the same one we supplied */
			if (rx.strptr != buffer) RexxFreeMemory(rx.strptr);
		}

		else
			printf("Script didn't return anything.\n");
	}

	/* Wait for user to press ENTER before ending */
	printf("Press ENTER to end...\n");
	scanf("%c", buffer);

	return(0);
}
