/* Running a script, and passing it some args */

#ifdef WIN32
#include <windows.h>
#endif
#include <stdio.h>
#include "..\rexxsaa.h"

char Data1[] = {'A','r','g',' ','1'};
char Data2[] = {'A','r','g',' ','2'};
char Data3[] = {'A','r','g',' ','3'};

int main(int argc, char **argv)
{
	APIRET		err;
	RXSTRING	args[3];	/* Here's our array of 3 RXSTRINGs */
	char		chr;

	/* Initialize the first arg to "Arg 1" */
	args[0].strptr = Data1;
	args[0].strlength = sizeof(Data1);

	/* Initialize the first arg to "Arg 2" */
	args[1].strptr = Data2;
	args[1].strlength = sizeof(Data2);

	/* Initialize the first arg to "Arg 3" */
	args[2].strptr = Data3;
	args[2].strlength = sizeof(Data3);

	/* Run the REXX Script named "test.rex" in the current directory */
	err = RexxStart(3,				/* How many args we're passing */
					&args[0],		/* The base of our array of args */
					"test.rex",		/* name of REXX script */
					0, 0, RXSUBROUTINE, 0, 0, 0);

	/* Was there an error running the script? */
	if (err)
	{
		/* Yes. Print the error number except if using Reginald. Reginald's RexxStart()
		   always displays the error for you. Other interpreters are inconsistent.
		   Sometimes they do and sometimes they don't
		*/
#ifndef USING_REGINALD
		printf("RexxStart() error: %d\n", err);
#endif
	}

	/* Wait for user to press ENTER before ending */
	printf("Press ENTER to end...\n");
	scanf("%c", &chr);

	return(0);
}
