/* An example that registers an External Function that sets a variable in the REXX script */

#ifdef WIN32
#include <windows.h>
#endif
#include <stdio.h>
#define RX_STRONGTYPING
#include "..\rexxsaa.h"





/* Here's our REXX-callable function that we install via
   RexxRegisterFunctionExe(). This sets a REXX variable (in
   the script) named "MyVar" to the value "Hi there".
 */

APIRET APIENTRY SetMyVar(PUCHAR name, ULONG numargs, RXSTRING args[], PSZ queuename, PRXSTRING retstr)
{
	SHVBLOCK block;
	APIRET   err;

	/* We don't return a value */
	retstr->strlength = 0;

	/* Let's set the value of MyVar */

	/* We're using only 1 SHVBLOCK (ie, 1 operation) */
	block.shvnext = 0;

	/* The variable name is "MyVar". Doesn't have
		to be nul-terminated, but it's easier here */
	block.shvname.strptr = "MyVar";
	block.shvname.strlength = strlen(block.shvname.strptr);

	/* Set the value to "Hi there" Again, doesn't
	have to be nul-terminated */
	block.shvvalue.strptr = "Hi there";
	block.shvvalue.strlength = strlen(block.shvvalue.strptr);

	/* The operation is to set the variable */
	block.shvcode = RXSHV_SET;

	/* Do that operation */
	err = RexxVariablePool(&block);

	/* An error? We ignore the situation where the
		variable didn't yet exist (ie, we created it anew) */
	if (err > 1)

		/* Let the interpreter know by triggering SYNTAX
			condition with an error message that there
			was an interpreter error. */
		return(RXERR_INTERPRETER_FAILURE);

	/* Return successfully */
	return(RXFUNC_OK);
}






int main(int argc, char **argv)
{
	APIRET	err;
	char	chr;

	/* Register our function called "SetMyVar() */
	err = RexxRegisterFunctionExe("SetMyVar", SetMyVar);
	if (err)
	{
		printf("Error #%ld registering SetMyVar()\n", err);
	}
	else
	{
		/* Run the REXX Script named "test.rex" in the current directory */
		err = RexxStart(0, 0, "test.rex", 0, 0, RXSUBROUTINE, 0, 0, 0);

		/* Was there an error running the script? */
		if (err)
		{
			/* Yes. Print the error number except if using Reginald. Reginald's RexxStart()
			   always displays the error for you. Other interpreters are inconsistent.
			   Sometimes they do and sometimes they don't
			*/
#ifndef USING_REGINALD
			printf("RexxStart() error: %d\n", err);
#endif
		}

		/* Deregister "SetMyVar() */
		err = RexxDeregisterFunction("SetMyVar");
		if (err)
		{
			printf("Error #%ld deregistering SetMyVar()\n", err);
		}
	}


	/* Wait for user to press ENTER before ending */
	printf("Press ENTER to end...\n");
	scanf("%c", &chr);

	return(0);
}
