/* Very simple example of running a script. No args, and no return value */

#ifdef WIN32
#include <windows.h>
#endif
#include <stdio.h>
#include "..\rexxsaa.h"

int main(int argc, char **argv)
{
	APIRET	err;
	char	chr;

	/* Run the REXX Script named "test.rex" in the current directory */
	err = RexxStart(0, 0,
					"test.rex",    /* name of REXX script */
					0, 0, RXSUBROUTINE, 0, 0, 0);

	/* Was there an error running the script? */
	if (err)
	{
		/* Yes. Print the error number except if using Reginald. Reginald's RexxStart()
		   always displays the error for you. Other interpreters are inconsistent.
		   Sometimes they do and sometimes they don't
		*/
#ifndef USING_REGINALD
		printf("RexxStart() error: %d\n", err);
#endif
	}

	/* Wait for user to press ENTER before ending */
	printf("Press ENTER to end...\n");
	scanf("%c", &chr);

	return(0);
}
